/*
 * Decompiled with CFR 0.152.
 */
package org.testng.log4testng;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.testng.collections.Maps;

public class Logger {
    private static int i = 0;
    private static final int TRACE = i++;
    private static final int DEBUG = i++;
    private static final int INFO = i++;
    static final int WARN = i++;
    private static final int ERROR = i++;
    private static final int FATAL = i++;
    private static final int LEVEL_COUNT = i;
    private static final String PREFIX = "log4testng.";
    private static final String LOGGER_PREFIX = "log4testng.logger.";
    private static final String ROOT_LOGGER = "log4testng.rootLogger";
    private static final String DEBUG_PROPERTY = "log4testng.debug";
    static PrintStream err = System.err;
    static PrintStream out = System.out;
    private static final String[] levelNames = new String[LEVEL_COUNT];
    private static final Map<String, Integer> levelMap;
    static boolean initialized;
    private static final Map<String, Integer> loggerLevels;
    static final Map<Class, Logger> loggers;
    static int rootLoggerLevel;
    static boolean debug;
    private final int level;
    private final Class klass;
    private final String m_className;

    public static synchronized Logger getLogger(Class pClass) {
        Logger.initialize();
        Logger logger = loggers.get(pClass);
        if (logger != null) {
            return logger;
        }
        int level = Logger.getLevel(pClass);
        logger = new Logger(pClass, level);
        loggers.put(pClass, logger);
        return logger;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(TRACE);
    }

    public void trace(Object message) {
        this.log(TRACE, message, null);
    }

    public void trace(Object message, Throwable t2) {
        this.log(TRACE, message, t2);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(DEBUG);
    }

    public void debug(Object message) {
        this.log(DEBUG, message, null);
    }

    public void debug(Object message, Throwable t2) {
        this.log(DEBUG, message, t2);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(INFO);
    }

    public void info(Object message) {
        this.log(INFO, message, null);
    }

    public void info(Object message, Throwable t2) {
        this.log(INFO, message, t2);
    }

    public void warn(Object message) {
        this.log(WARN, message, null);
    }

    public void warn(Object message, Throwable t2) {
        this.log(WARN, message, t2);
    }

    public void error(Object message) {
        this.log(ERROR, message, null);
    }

    public void error(Object message, Throwable t2) {
        this.log(ERROR, message, t2);
    }

    public void fatal(Object message) {
        this.log(FATAL, message, null);
    }

    public void fatal(Object message, Throwable t2) {
        this.log(FATAL, message, t2);
    }

    private Logger(Class pClass, int pLevel) {
        this.level = pLevel;
        this.klass = pClass;
        this.m_className = pClass.getName().substring(pClass.getName().lastIndexOf(46) + 1);
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("log4testng.properties");
        if (is == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Logger.checkProperties(properties);
    }

    static void checkProperties(Properties pProperties) {
        String debugStr = pProperties.getProperty(DEBUG_PROPERTY);
        if (debugStr != null) {
            if (debugStr.equalsIgnoreCase("true")) {
                debug = true;
            } else if (debugStr.equalsIgnoreCase("false")) {
                debug = false;
            } else {
                throw new IllegalArgumentException("Unknown log4testng.debug value " + debugStr);
            }
        }
        Logger.loglog4testng("log4testng.debug set to " + debug);
        String rootLevelStr = pProperties.getProperty(ROOT_LOGGER);
        if (rootLevelStr != null) {
            Integer ilevel = levelMap.get(rootLevelStr.toUpperCase(Locale.ROOT));
            if (ilevel == null) {
                throw new IllegalArgumentException("Unknown level for log4testng.rootLogger " + rootLevelStr + " in log4testng.properties");
            }
            rootLoggerLevel = ilevel;
            Logger.loglog4testng("Root level logger set to " + rootLevelStr + " level.");
        }
        for (Map.Entry<Object, Object> entry : pProperties.entrySet()) {
            String logger = (String)entry.getKey();
            String level = (String)entry.getValue();
            if (!logger.startsWith(PREFIX)) {
                throw new IllegalArgumentException("Illegal property value: " + logger);
            }
            if (logger.equals(DEBUG_PROPERTY) || logger.equals(ROOT_LOGGER)) continue;
            if (!logger.startsWith(LOGGER_PREFIX)) {
                throw new IllegalArgumentException("Illegal property value: " + logger);
            }
            Integer ilevel = levelMap.get(level.toUpperCase(Locale.ROOT));
            if (ilevel == null) {
                throw new IllegalArgumentException("Unknown level " + level + " for logger " + logger + " in log4testng.properties");
            }
            loggerLevels.put(logger.substring(LOGGER_PREFIX.length()), ilevel);
            Logger.loglog4testng("logger " + logger + " set to " + ilevel + " level.");
        }
    }

    private static int getLevel(Class pClass) {
        String name = pClass.getName();
        Logger.loglog4testng("Getting level for logger " + name);
        while (true) {
            Integer level;
            if ((level = loggerLevels.get(name)) != null) {
                Logger.loglog4testng("Found level " + level + " for logger " + name);
                return level;
            }
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                Logger.loglog4testng("Found level " + rootLoggerLevel + " for root logger");
                return rootLoggerLevel;
            }
            name = name.substring(0, dot);
        }
    }

    private boolean isLevelEnabled(int pLevel) {
        return this.level <= pLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(int pLevel, Object pMessage, Throwable pT) {
        if (this.isLevelEnabled(pLevel)) {
            PrintStream ps;
            PrintStream printStream = ps = pLevel >= ERROR ? err : out;
            if (null != pT) {
                PrintStream printStream2 = ps;
                synchronized (printStream2) {
                    ps.println("[" + this.m_className + "] [" + levelNames[pLevel] + "] " + pMessage);
                    pT.printStackTrace(ps);
                }
            } else {
                ps.println("[" + this.m_className + "] [" + levelNames[pLevel] + "] " + pMessage);
            }
        }
    }

    private static void loglog4testng(String pmessage) {
        if (debug) {
            out.println("[log4testng] [debug] " + pmessage);
        }
    }

    static {
        Logger.levelNames[Logger.TRACE] = "TRACE";
        Logger.levelNames[Logger.DEBUG] = "DEBUG";
        Logger.levelNames[Logger.INFO] = "INFO";
        Logger.levelNames[Logger.WARN] = "WARN";
        Logger.levelNames[Logger.ERROR] = "ERROR";
        Logger.levelNames[Logger.FATAL] = "FATAL";
        levelMap = Maps.newHashMap();
        for (i = 0; i < LEVEL_COUNT; ++i) {
            levelMap.put(levelNames[i], i);
        }
        loggerLevels = Maps.newHashMap();
        loggers = Maps.newHashMap();
        rootLoggerLevel = WARN;
        debug = false;
    }
}

