/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.object;

import io.ray.api.ObjectRef;
import io.ray.api.WaitResult;
import io.ray.api.exception.RayException;
import io.ray.api.id.ActorId;
import io.ray.api.id.ObjectId;
import io.ray.runtime.context.WorkerContext;
import io.ray.runtime.generated.Common;
import io.ray.runtime.object.NativeRayObject;
import io.ray.runtime.object.ObjectRefImpl;
import io.ray.runtime.object.ObjectSerializer;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class ObjectStore {
    private final WorkerContext workerContext;

    public ObjectStore(WorkerContext workerContext) {
        this.workerContext = workerContext;
    }

    public abstract ObjectId putRaw(NativeRayObject var1);

    public abstract ObjectId putRaw(NativeRayObject var1, ActorId var2);

    public abstract void putRaw(NativeRayObject var1, ObjectId var2);

    public ObjectId put(Object object) {
        if (object instanceof NativeRayObject) {
            throw new IllegalArgumentException("Trying to put a NativeRayObject. Please use putRaw instead.");
        }
        return this.putRaw(ObjectSerializer.serialize(object));
    }

    public ObjectId put(Object object, ActorId ownerActorId) {
        if (object instanceof NativeRayObject) {
            throw new IllegalArgumentException("Trying to put a NativeRayObject. Please use putRaw instead.");
        }
        return this.putRaw(ObjectSerializer.serialize(object), ownerActorId);
    }

    public void put(Object object, ObjectId objectId) {
        if (object instanceof NativeRayObject) {
            throw new IllegalArgumentException("Trying to put a NativeRayObject. Please use putRaw instead.");
        }
        this.putRaw(ObjectSerializer.serialize(object), objectId);
    }

    public abstract List<NativeRayObject> getRaw(List<ObjectId> var1, long var2);

    public <T> List<T> get(List<ObjectId> ids, Class<?> elementType) {
        return this.get(ids, elementType, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> get(List<ObjectId> ids, Class<?> elementType, long timeoutMs) {
        List<NativeRayObject> dataAndMetaList = this.getRaw(ids, timeoutMs);
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < dataAndMetaList.size(); ++i) {
            NativeRayObject dataAndMeta = dataAndMetaList.get(i);
            Object object = null;
            if (dataAndMeta != null) {
                try {
                    ObjectSerializer.setOuterObjectId(ids.get(i));
                    object = ObjectSerializer.deserialize(dataAndMeta, ids.get(i), elementType);
                }
                finally {
                    ObjectSerializer.resetOuterObjectId();
                }
            }
            if (object instanceof RayException) {
                throw (RayException)object;
            }
            results.add(object);
        }
        Preconditions.checkState(dataAndMetaList.stream().allMatch(Objects::nonNull));
        return results;
    }

    public abstract List<Boolean> wait(List<ObjectId> var1, int var2, long var3, boolean var5);

    public <T> WaitResult<T> wait(List<ObjectRef<T>> waitList, int numReturns, int timeoutMs, boolean fetchLocal) {
        Preconditions.checkNotNull(waitList);
        if (waitList.isEmpty()) {
            return new WaitResult(Collections.emptyList(), Collections.emptyList());
        }
        List<ObjectId> ids = waitList.stream().map(ref -> ((ObjectRefImpl)ref).getId()).collect(Collectors.toList());
        List<Boolean> ready = this.wait(ids, numReturns, (long)timeoutMs, fetchLocal);
        ArrayList readyList = new ArrayList();
        ArrayList unreadyList = new ArrayList();
        for (int i = 0; i < ready.size(); ++i) {
            if (ready.get(i).booleanValue()) {
                readyList.add(waitList.get(i));
                continue;
            }
            unreadyList.add(waitList.get(i));
        }
        return new WaitResult(readyList, unreadyList);
    }

    public abstract void delete(List<ObjectId> var1, boolean var2);

    public abstract void addLocalReference(ObjectId var1);

    public abstract void removeLocalReference(ObjectId var1);

    public abstract Common.Address getOwnerAddress(ObjectId var1);

    public abstract byte[] getOwnershipInfo(ObjectId var1);

    public abstract void registerOwnershipInfoAndResolveFuture(ObjectId var1, ObjectId var2, byte[] var3);
}

