/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.object;

import io.ray.api.Ray;
import io.ray.api.id.ActorId;
import io.ray.api.id.BaseId;
import io.ray.api.id.ObjectId;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.context.WorkerContext;
import io.ray.runtime.generated.Common;
import io.ray.runtime.object.NativeRayObject;
import io.ray.runtime.object.ObjectStore;
import io.ray.shaded.com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeObjectStore
extends ObjectStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeObjectStore.class);
    private final ReadWriteLock shutdownLock;

    public NativeObjectStore(WorkerContext workerContext, ReadWriteLock shutdownLock) {
        super(workerContext);
        this.shutdownLock = shutdownLock;
    }

    @Override
    public ObjectId putRaw(NativeRayObject obj) {
        return new ObjectId(NativeObjectStore.nativePut(obj, null));
    }

    @Override
    public ObjectId putRaw(NativeRayObject obj, ActorId ownerActorId) {
        byte[] serializedOwnerAddressBytes = ((AbstractRayRuntime)Ray.internal()).getGcsClient().getActorAddress(ownerActorId);
        return new ObjectId(NativeObjectStore.nativePut(obj, serializedOwnerAddressBytes));
    }

    @Override
    public void putRaw(NativeRayObject obj, ObjectId objectId) {
        NativeObjectStore.nativePut(objectId.getBytes(), obj);
    }

    @Override
    public List<NativeRayObject> getRaw(List<ObjectId> objectIds, long timeoutMs) {
        return NativeObjectStore.nativeGet(NativeObjectStore.toBinaryList(objectIds), timeoutMs);
    }

    @Override
    public List<Boolean> wait(List<ObjectId> objectIds, int numObjects, long timeoutMs, boolean fetchLocal) {
        return NativeObjectStore.nativeWait(NativeObjectStore.toBinaryList(objectIds), numObjects, timeoutMs, fetchLocal);
    }

    @Override
    public void delete(List<ObjectId> objectIds, boolean localOnly) {
        NativeObjectStore.nativeDelete(NativeObjectStore.toBinaryList(objectIds), localOnly);
    }

    @Override
    public void addLocalReference(ObjectId objectId) {
        NativeObjectStore.nativeAddLocalReference(objectId.getBytes());
    }

    @Override
    public void removeLocalReference(ObjectId objectId) {
        Lock readLock = this.shutdownLock.readLock();
        readLock.lock();
        try {
            NativeObjectStore.nativeRemoveLocalReference(objectId.getBytes());
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public byte[] getOwnershipInfo(ObjectId objectId) {
        return NativeObjectStore.nativeGetOwnershipInfo(objectId.getBytes());
    }

    @Override
    public void registerOwnershipInfoAndResolveFuture(ObjectId objectId, ObjectId outerObjectId, byte[] ownerAddress) {
        byte[] outer = null;
        if (outerObjectId != null) {
            outer = outerObjectId.getBytes();
        }
        NativeObjectStore.nativeRegisterOwnershipInfoAndResolveFuture(objectId.getBytes(), outer, ownerAddress);
    }

    public Map<ObjectId, long[]> getAllReferenceCounts() {
        HashMap<ObjectId, long[]> referenceCounts = new HashMap<ObjectId, long[]>();
        for (Map.Entry<byte[], long[]> entry : NativeObjectStore.nativeGetAllReferenceCounts().entrySet()) {
            referenceCounts.put(new ObjectId(entry.getKey()), entry.getValue());
        }
        return referenceCounts;
    }

    @Override
    public Common.Address getOwnerAddress(ObjectId id) {
        try {
            return Common.Address.parseFrom(NativeObjectStore.nativeGetOwnerAddress(id.getBytes()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<byte[]> toBinaryList(List<ObjectId> ids) {
        return ids.stream().map(BaseId::getBytes).collect(Collectors.toList());
    }

    private static native byte[] nativePut(NativeRayObject var0, byte[] var1);

    private static native void nativePut(byte[] var0, NativeRayObject var1);

    private static native List<NativeRayObject> nativeGet(List<byte[]> var0, long var1);

    private static native List<Boolean> nativeWait(List<byte[]> var0, int var1, long var2, boolean var4);

    private static native void nativeDelete(List<byte[]> var0, boolean var1);

    private static native void nativeAddLocalReference(byte[] var0);

    private static native void nativeRemoveLocalReference(byte[] var0);

    private static native Map<byte[], long[]> nativeGetAllReferenceCounts();

    private static native byte[] nativeGetOwnerAddress(byte[] var0);

    private static native byte[] nativeGetOwnershipInfo(byte[] var0);

    private static native void nativeRegisterOwnershipInfoAndResolveFuture(byte[] var0, byte[] var1, byte[] var2);
}

