/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.metric;

import io.ray.runtime.metric.MetricType;
import io.ray.runtime.metric.TagKey;
import io.ray.shaded.com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;

public class MetricId {
    private final MetricType type;
    private final String name;
    private final Map<TagKey, String> tags;

    public MetricId(MetricType type, String name, Map<TagKey, String> tags) {
        this.type = type;
        this.name = name;
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricId)) {
            return false;
        }
        MetricId metricId = (MetricId)o;
        return this.type == metricId.type && Objects.equals(this.name, metricId.name) && Objects.equals(this.tags, metricId.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.tags});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("name", this.name).add("tags", this.tags).toString();
    }

    public MetricType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Map<TagKey, String> getTags() {
        return this.tags;
    }
}

