/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.metric;

import io.ray.runtime.metric.NativeMetric;
import io.ray.runtime.metric.TagKey;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class Metric {
    protected String name;
    protected AtomicDouble value;
    protected long metricNativePointer = 0L;
    protected Map<TagKey, String> tags;

    public Metric(String name, Map<TagKey, String> tags) {
        Preconditions.checkNotNull(tags, "Metric tags map must not be null.");
        Preconditions.checkNotNull(name, "Metric name must not be null.");
        this.name = name;
        this.tags = tags;
        this.value = new AtomicDouble();
    }

    public void record() {
        Preconditions.checkState(this.metricNativePointer != 0L, "Metric native pointer must not be 0.");
        ArrayList<TagKey> nativeTagKeyList = new ArrayList<TagKey>();
        ArrayList<String> tagValues = new ArrayList<String>();
        for (Map.Entry<TagKey, String> entry : this.tags.entrySet()) {
            nativeTagKeyList.add(entry.getKey());
            tagValues.add(entry.getValue());
        }
        NativeMetric.recordNative(this.metricNativePointer, this.getAndReset(), nativeTagKeyList.stream().map(TagKey::getTagKey).collect(Collectors.toList()), tagValues);
    }

    protected abstract double getAndReset();

    public abstract void update(double var1);

    public void update(double value, Map<TagKey, String> tags) {
        this.update(value);
        this.tags = tags;
    }

    public void update(Map<String, String> tags, double value) {
        this.update(value);
        this.tags = TagKey.tagsFromMap(tags);
    }

    public Map<String, String> getTagMap() {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        for (Map.Entry<TagKey, String> entry : this.tags.entrySet()) {
            tagMap.put(entry.getKey().getTagKey(), entry.getValue());
        }
        return tagMap;
    }

    public void unregister() {
        if (0L != this.metricNativePointer) {
            NativeMetric.unregisterMetricNative(this.metricNativePointer);
        }
        this.metricNativePointer = 0L;
    }
}

