/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.id;

import io.ray.api.id.BaseId;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class JobId
extends BaseId
implements Serializable {
    public static final int LENGTH = 4;
    public static final JobId NIL = JobId.genNil();

    private JobId(byte[] id) {
        super(id);
    }

    public static JobId fromBytes(byte[] bytes) {
        return new JobId(bytes);
    }

    public static JobId fromHexString(String hex) {
        return new JobId(JobId.hexString2Bytes(hex));
    }

    public static JobId fromByteBuffer(ByteBuffer bb) {
        return new JobId(JobId.byteBuffer2Bytes(bb));
    }

    public static JobId fromInt(int value) {
        if ((double)value > Math.pow(256.0, 4.0)) {
            throw new IllegalArgumentException("The integer value is invalid for a JobId. Value: " + value);
        }
        byte[] bytes = new byte[4];
        ByteBuffer wbb = ByteBuffer.wrap(bytes);
        wbb.order(ByteOrder.LITTLE_ENDIAN);
        wbb.putInt(value);
        wbb.flip();
        wbb.limit(4);
        return JobId.fromByteBuffer(wbb);
    }

    private static JobId genNil() {
        byte[] b = new byte[4];
        Arrays.fill(b, (byte)-1);
        return new JobId(b);
    }

    @Override
    public int size() {
        return 4;
    }
}

