/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.call;

import io.ray.api.ActorHandle;
import io.ray.api.ObjectRef;
import io.ray.api.Ray;
import io.ray.api.function.RayFuncR;
import io.ray.api.options.CallOptions;

public class ActorTaskCaller<R> {
    private final ActorHandle actor;
    private final RayFuncR<R> func;
    private final Object[] args;
    private CallOptions.Builder builder = new CallOptions.Builder();

    public ActorTaskCaller(ActorHandle actor, RayFuncR<R> func, Object[] args) {
        this.actor = actor;
        this.func = func;
        this.args = args;
    }

    public ActorTaskCaller<R> setConcurrencyGroup(String name) {
        this.builder.setConcurrencyGroupName(name);
        return this.self();
    }

    private ActorTaskCaller<R> self() {
        return this;
    }

    public ObjectRef<R> remote() {
        return Ray.internal().callActor(this.actor, this.func, this.args, this.builder.build());
    }
}

