/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.render;

import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.render.MultiValueRenderer;
import com.github.fge.uritemplate.vars.values.VariableValue;
import io.ray.shaded.com.google.common.collect.ImmutableList;
import io.ray.shaded.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public final class ListRenderer
extends MultiValueRenderer {
    public ListRenderer(ExpressionType type) {
        super(type);
    }

    @Override
    protected List<String> renderNamedExploded(String varname, VariableValue value) {
        ArrayList<String> ret = Lists.newArrayList();
        for (String element : value.getListValue()) {
            ret.add(element.isEmpty() ? varname + this.ifEmpty : varname + '=' + this.pctEncode(element));
        }
        return ret;
    }

    @Override
    protected List<String> renderUnnamedExploded(VariableValue value) {
        ArrayList<String> ret = Lists.newArrayList();
        for (String element : value.getListValue()) {
            ret.add(this.pctEncode(element));
        }
        return ret;
    }

    @Override
    protected List<String> renderNamedNormal(String varname, VariableValue value) {
        StringBuilder sb = new StringBuilder(varname);
        if (value.isEmpty()) {
            return ImmutableList.of(sb.append(this.ifEmpty).toString());
        }
        sb.append('=');
        ArrayList<String> elements = Lists.newArrayList();
        for (String element : value.getListValue()) {
            elements.add(this.pctEncode(element));
        }
        COMMA.appendTo(sb, (Iterable<? extends Object>)elements);
        return ImmutableList.of(sb.toString());
    }

    @Override
    protected List<String> renderUnnamedNormal(VariableValue value) {
        if (value.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<String> ret = Lists.newArrayList();
        for (String element : value.getListValue()) {
            ret.add(this.pctEncode(element));
        }
        return ImmutableList.of(COMMA.join(ret));
    }
}

