/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Maps;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;
import org.testng.xml.XmlSuite;

public class TimesPanel
extends BaseMultiSuitePanel {
    private Map<String, Long> m_totalTime = Maps.newHashMap();

    public TimesPanel(Model model) {
        super(model);
    }

    @Override
    public String getPrefix() {
        return "times-";
    }

    @Override
    public String getHeader(ISuite suite) {
        return "Times for " + suite.getName();
    }

    private String js(ISuite suite) {
        String functionName = "tableData_" + TimesPanel.suiteToTag(suite);
        StringBuilder result = new StringBuilder("suiteTableInitFunctions.push('" + functionName + "');\nfunction " + functionName + "() {\nvar data = new google.visualization.DataTable();\ndata.addColumn('number', 'Number');\ndata.addColumn('string', 'Method');\ndata.addColumn('string', 'Class');\ndata.addColumn('number', 'Time (ms)');\n");
        List<ITestResult> allTestResults = this.getModel().getAllTestResults(suite);
        result.append("data.addRows(").append(allTestResults.size()).append(");\n");
        allTestResults.sort((o1, o2) -> (int)(TimesPanel.time(o2) - TimesPanel.time(o1)));
        int index = 0;
        for (ITestResult tr : allTestResults) {
            ITestNGMethod m4 = tr.getMethod();
            long time = tr.getEndMillis() - tr.getStartMillis();
            result.append("data.setCell(").append(index).append(", 0, ").append(index).append(")\n").append("data.setCell(").append(index).append(", 1, '").append(m4.getMethodName()).append("')\n").append("data.setCell(").append(index).append(", 2, '").append(m4.getTestClass().getName()).append("')\n").append("data.setCell(").append(index).append(", 3, ").append(time).append(");\n");
            Long total = this.m_totalTime.get(suite.getName());
            if (total == null) {
                total = 0L;
            }
            this.m_totalTime.put(suite.getName(), total + time);
            ++index;
        }
        result.append("window.suiteTableData['").append(TimesPanel.suiteToTag(suite)).append("']").append("= { tableData: data, tableDiv: 'times-div-").append(TimesPanel.suiteToTag(suite)).append("'}\n").append("return data;\n").append("}\n");
        return result.toString();
    }

    @Override
    public String getContent(ISuite suite, XMLStringBuffer main) {
        XMLStringBuffer xsb = new XMLStringBuffer(main.getCurrentIndent());
        xsb.push("div", "class", "times-div");
        xsb.push("script", "type", "text/javascript");
        xsb.addString(this.js(suite));
        xsb.pop("script");
        long time = this.maxTime(suite);
        xsb.addRequired("span", String.format("Total running time: %s", this.prettyDuration(time)), "class", "suite-total-time");
        xsb.push("div", "id", "times-div-" + TimesPanel.suiteToTag(suite));
        xsb.pop("div");
        xsb.pop("div");
        return xsb.toXML();
    }

    private String prettyDuration(long totalTime) {
        String result = totalTime < 1000L ? totalTime + " ms" : (totalTime < 60000L ? totalTime / 1000L + " seconds" : (totalTime < 3600000L ? totalTime / 1000L / 60L + " minutes" : totalTime / 1000L / 60L / 60L + " hours"));
        return result;
    }

    @Override
    public String getNavigatorLink(ISuite suite) {
        return "Times";
    }

    private static long time(ITestResult o1) {
        return o1.getEndMillis() - o1.getStartMillis();
    }

    private long maxTime(ISuite suite) {
        boolean testsInParallel = XmlSuite.ParallelMode.TESTS.equals((Object)suite.getXmlSuite().getParallel());
        Long result = this.m_totalTime.get(suite.getName());
        if (result == null) {
            return 0L;
        }
        if (!testsInParallel) {
            return result;
        }
        Optional<ITestContext> maxValue = suite.getResults().values().stream().map(ISuiteResult::getTestContext).max(Comparator.comparing(TimesPanel::time));
        if (maxValue.isPresent()) {
            return TimesPanel.time(maxValue.get());
        }
        return result;
    }

    private static Long time(ITestContext ctx) {
        return ctx.getEndDate().getTime() - ctx.getStartDate().getTime();
    }
}

