/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.testng.IClass;
import org.testng.IRetryAnalyzer;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.IParameterInfo;
import org.testng.internal.MethodHelper;
import org.testng.internal.XmlTestUtils;
import org.testng.internal.annotations.DisabledRetryAnalyzer;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.IInvocationStatus;
import org.testng.internal.objects.Dispenser;
import org.testng.internal.objects.pojo.BasicAttributes;
import org.testng.internal.objects.pojo.CreationAttributes;
import org.testng.xml.XmlTest;

public abstract class BaseTestMethod
implements ITestNGMethod,
IInvocationStatus {
    private static final Pattern SPACE_SEPARATOR_PATTERN = Pattern.compile(" +");
    protected ITestClass m_testClass;
    protected final Class<?> m_methodClass;
    protected final ConstructorOrMethod m_method;
    private String m_signature;
    protected String m_id = "";
    protected long m_date = -1L;
    protected final IAnnotationFinder m_annotationFinder;
    protected String[] m_groups = new String[0];
    protected String[] m_groupsDependedUpon = new String[0];
    protected String[] m_methodsDependedUpon = new String[0];
    protected String[] m_beforeGroups = new String[0];
    protected String[] m_afterGroups = new String[0];
    private boolean m_isAlwaysRun;
    private boolean m_enabled;
    private final String m_methodName;
    private String m_missingGroup;
    private String m_description = null;
    protected AtomicInteger m_currentInvocationCount = new AtomicInteger(0);
    private int m_parameterInvocationCount = 1;
    private Callable<Boolean> m_moreInvocationChecker;
    private IRetryAnalyzer m_retryAnalyzer = null;
    private Class<? extends IRetryAnalyzer> m_retryAnalyzerClass = null;
    private boolean m_skipFailedInvocations = true;
    private long m_invocationTimeOut = 0L;
    private List<Integer> m_invocationNumbers = Lists.newArrayList();
    private final Collection<Integer> m_failedInvocationNumbers = new ConcurrentLinkedQueue<Integer>();
    private long m_timeOut = 0L;
    private boolean m_ignoreMissingDependencies;
    private int m_priority;
    private int m_interceptedPriority;
    private XmlTest m_xmlTest;
    private final Object m_instance;
    private final Map<String, IRetryAnalyzer> m_testMethodToRetryAnalyzer = Maps.newConcurrentMap();
    protected final ITestObjectFactory m_objectFactory;
    private long invocationTime;

    public BaseTestMethod(ITestObjectFactory objectFactory, String methodName, ConstructorOrMethod com, IAnnotationFinder annotationFinder, Object instance) {
        this.m_objectFactory = objectFactory;
        this.m_methodClass = com.getDeclaringClass();
        this.m_method = com;
        this.m_methodName = methodName;
        this.m_annotationFinder = annotationFinder;
        this.m_instance = instance;
    }

    @Override
    public boolean isAlwaysRun() {
        return this.m_isAlwaysRun;
    }

    protected void setAlwaysRun(boolean alwaysRun) {
        this.m_isAlwaysRun = alwaysRun;
    }

    @Override
    public Class<?> getRealClass() {
        return this.m_methodClass;
    }

    @Override
    public ITestClass getTestClass() {
        return this.m_testClass;
    }

    @Override
    public void setTestClass(ITestClass tc) {
        if (tc == null) {
            throw new IllegalArgumentException("test class cannot be null");
        }
        boolean assignable = this.m_method.getDeclaringClass().isAssignableFrom(tc.getRealClass());
        if (!assignable) {
            throw new IllegalArgumentException("mismatch in classes between " + tc.getName() + " and " + this.m_method.getDeclaringClass().getName());
        }
        this.m_testClass = tc;
    }

    @Override
    public String getMethodName() {
        return this.m_methodName;
    }

    @Override
    public Object getInstance() {
        return IParameterInfo.embeddedInstance(this.m_instance);
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_testClass.getInstanceHashCodes();
    }

    @Override
    public String[] getGroups() {
        return this.m_groups;
    }

    @Override
    public String[] getGroupsDependedUpon() {
        return this.m_groupsDependedUpon;
    }

    @Override
    public String[] getMethodsDependedUpon() {
        return this.m_methodsDependedUpon;
    }

    @Override
    public boolean isTest() {
        return false;
    }

    @Override
    public boolean isBeforeSuiteConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterSuiteConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeTestConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterTestConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeGroupsConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterGroupsConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeClassConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterClassConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeMethodConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterMethodConfiguration() {
        return false;
    }

    @Override
    public long getTimeOut() {
        return this.m_timeOut != 0L ? this.m_timeOut : (this.m_xmlTest != null ? this.m_xmlTest.getTimeOut(0L) : 0L);
    }

    @Override
    public void setTimeOut(long timeOut) {
        this.m_timeOut = timeOut;
    }

    @Override
    public int getInvocationCount() {
        return 1;
    }

    @Override
    public void setInvocationCount(int counter) {
    }

    @Override
    public int getSuccessPercentage() {
        return 100;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public void setId(String id) {
        this.m_id = id;
    }

    @Override
    public long getDate() {
        return this.m_date;
    }

    @Override
    public void setDate(long date) {
        this.m_date = date;
    }

    @Override
    public boolean canRunFromClass(IClass testClass) {
        return this.m_methodClass.isAssignableFrom(testClass.getRealClass());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseTestMethod other = (BaseTestMethod)obj;
        boolean isEqual = this.m_testClass == null ? other.m_testClass == null : other.m_testClass != null && this.m_testClass.getRealClass().equals(other.m_testClass.getRealClass()) && this.getInstance() == other.getInstance();
        return isEqual && this.getConstructorOrMethod().equals(other.getConstructorOrMethod());
    }

    public int hashCode() {
        int hash = this.m_method.hashCode();
        if (this.m_instance != null) {
            hash = hash * 31 + System.identityHashCode(this.m_instance);
        }
        return hash;
    }

    protected void initGroups(Class<? extends ITestOrConfiguration> annotationClass) {
        ITestOrConfiguration annotation = this.getAnnotationFinder().findAnnotation(this.getConstructorOrMethod(), annotationClass);
        Object object = this.getInstance();
        Class<?> clazz = this.getConstructorOrMethod().getDeclaringClass();
        if (object != null) {
            clazz = object.getClass();
        }
        ITestOrConfiguration classAnnotation = this.getAnnotationFinder().findAnnotation(clazz, annotationClass);
        this.setGroups(this.getStringArray(null != annotation ? annotation.getGroups() : null, null != classAnnotation ? classAnnotation.getGroups() : null));
        this.initRestOfGroupDependencies(annotationClass);
    }

    protected void initBeforeAfterGroups(Class<? extends ITestOrConfiguration> annotationClass, String[] groups) {
        String[] groupsAtMethodLevel = this.calculateGroupsTouseConsideringValuesAndGroupValues(annotationClass, groups);
        this.setGroups(this.getStringArray(groupsAtMethodLevel, null));
        this.initRestOfGroupDependencies(annotationClass);
    }

    private String[] calculateGroupsTouseConsideringValuesAndGroupValues(Class<? extends ITestOrConfiguration> annotationClass, String[] groups) {
        if (groups == null || groups.length == 0) {
            ITestOrConfiguration annotation = this.getAnnotationFinder().findAnnotation(this.getConstructorOrMethod(), annotationClass);
            groups = null != annotation ? annotation.getGroups() : null;
        }
        return groups;
    }

    private void initRestOfGroupDependencies(Class<? extends ITestOrConfiguration> annotationClass) {
        ITestOrConfiguration annotation = this.getAnnotationFinder().findAnnotation(this.getConstructorOrMethod(), annotationClass);
        ITestOrConfiguration classAnnotation = this.getAnnotationFinder().findAnnotation(this.getConstructorOrMethod().getDeclaringClass(), annotationClass);
        Map<String, Set<String>> xgd = BaseTestMethod.calculateXmlGroupDependencies(this.m_xmlTest);
        List<String> xmlGroupDependencies = Lists.newArrayList();
        for (String g2 : this.getGroups()) {
            Set<String> gdu = xgd.get(g2);
            if (gdu == null) continue;
            xmlGroupDependencies.addAll(gdu);
        }
        this.setGroupsDependedUpon(this.getStringArray(null != annotation ? annotation.getDependsOnGroups() : null, null != classAnnotation ? classAnnotation.getDependsOnGroups() : null), xmlGroupDependencies);
        String[] methodsDependedUpon = this.getStringArray(null != annotation ? annotation.getDependsOnMethods() : null, null != classAnnotation ? classAnnotation.getDependsOnMethods() : null);
        for (int i = 0; i < methodsDependedUpon.length; ++i) {
            String m4 = methodsDependedUpon[i];
            if (m4.contains(".")) continue;
            m4 = MethodHelper.calculateMethodCanonicalName(this.m_methodClass, methodsDependedUpon[i]);
            methodsDependedUpon[i] = m4 != null ? m4 : methodsDependedUpon[i];
        }
        this.setMethodsDependedUpon(methodsDependedUpon);
    }

    private static Map<String, Set<String>> calculateXmlGroupDependencies(XmlTest xmlTest) {
        Map<String, Set<String>> result = Maps.newHashMap();
        if (xmlTest == null) {
            return result;
        }
        for (Map.Entry<String, String> e : xmlTest.getXmlDependencyGroups().entrySet()) {
            String name = e.getKey();
            String dependsOn = e.getValue();
            Set set = result.computeIfAbsent(name, s2 -> Sets.newHashSet());
            set.addAll(Arrays.asList(SPACE_SEPARATOR_PATTERN.split(dependsOn)));
        }
        return result;
    }

    protected IAnnotationFinder getAnnotationFinder() {
        return this.m_annotationFinder;
    }

    protected IClass getIClass() {
        return this.m_testClass;
    }

    static StringBuilder stringify(String cls, ConstructorOrMethod method) {
        StringBuilder result = new StringBuilder(cls).append(".").append(method.getName()).append("(");
        return result.append(method.stringifyParameterTypes()).append(")");
    }

    private String computeSignature() {
        String classLong = this.m_method.getDeclaringClass().getName();
        String cls = classLong.substring(classLong.lastIndexOf(".") + 1);
        StringBuilder result = BaseTestMethod.stringify(cls, this.m_method);
        result.append("[pri:").append(this.getPriority()).append(", instance:").append(this.getInstance()).append(this.instanceParameters()).append("]");
        return result.toString();
    }

    public String getSimpleName() {
        return this.m_method.getDeclaringClass().getSimpleName() + "." + this.m_method.getName();
    }

    private String instanceParameters() {
        IParameterInfo instance = this.getFactoryMethodParamsInfo();
        if (instance != null) {
            return ", instance params:" + Arrays.toString(instance.getParameters());
        }
        return "";
    }

    protected String getSignature() {
        if (this.m_signature == null) {
            this.m_signature = this.computeSignature();
        }
        return this.m_signature;
    }

    public String toString() {
        return this.getSignature();
    }

    protected String[] getStringArray(String[] methodArray, String[] classArray) {
        Set vResult = Sets.newHashSet();
        if (null != methodArray) {
            Collections.addAll(vResult, methodArray);
        }
        if (null != classArray) {
            Collections.addAll(vResult, classArray);
        }
        return vResult.toArray(new String[0]);
    }

    protected void setGroups(String[] groups) {
        this.m_groups = groups;
    }

    protected void setGroupsDependedUpon(String[] groups, Collection<String> xmlGroupDependencies) {
        List l = Lists.newArrayList();
        l.addAll(Arrays.asList(groups));
        l.addAll(xmlGroupDependencies);
        this.m_groupsDependedUpon = l.toArray(new String[0]);
    }

    protected void setMethodsDependedUpon(String[] methods) {
        this.m_methodsDependedUpon = methods;
    }

    @Override
    public void addMethodDependedUpon(String method) {
        String[] newMethods = new String[this.m_methodsDependedUpon.length + 1];
        newMethods[0] = method;
        System.arraycopy(this.m_methodsDependedUpon, 0, newMethods, 1, this.m_methodsDependedUpon.length);
        this.m_methodsDependedUpon = newMethods;
    }

    @Override
    public String getMissingGroup() {
        return this.m_missingGroup;
    }

    @Override
    public void setMissingGroup(String group) {
        this.m_missingGroup = group;
    }

    @Override
    public int getThreadPoolSize() {
        return 0;
    }

    @Override
    public void setThreadPoolSize(int threadPoolSize) {
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.m_enabled;
    }

    @Override
    public String[] getBeforeGroups() {
        return this.m_beforeGroups;
    }

    @Override
    public String[] getAfterGroups() {
        return this.m_afterGroups;
    }

    @Override
    public void incrementCurrentInvocationCount() {
        this.m_currentInvocationCount.incrementAndGet();
    }

    @Override
    public int getCurrentInvocationCount() {
        return this.m_currentInvocationCount.get();
    }

    @Override
    public void setParameterInvocationCount(int n) {
        this.m_parameterInvocationCount = n;
    }

    @Override
    public int getParameterInvocationCount() {
        return this.m_parameterInvocationCount;
    }

    @Override
    public void setMoreInvocationChecker(Callable<Boolean> moreInvocationChecker) {
        this.m_moreInvocationChecker = moreInvocationChecker;
    }

    @Override
    public boolean hasMoreInvocation() {
        if (this.m_moreInvocationChecker != null) {
            try {
                return this.m_moreInvocationChecker.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.getCurrentInvocationCount() < this.getInvocationCount() * this.getParameterInvocationCount();
    }

    @Override
    public abstract ITestNGMethod clone();

    @Override
    public IRetryAnalyzer getRetryAnalyzer(ITestResult result) {
        return this.getRetryAnalyzerConsideringMethodParameters(result);
    }

    @Override
    public void setRetryAnalyzerClass(Class<? extends IRetryAnalyzer> clazz) {
        this.m_retryAnalyzerClass = clazz == null ? DisabledRetryAnalyzer.class : clazz;
    }

    @Override
    public Class<? extends IRetryAnalyzer> getRetryAnalyzerClass() {
        return this.m_retryAnalyzerClass;
    }

    @Override
    public boolean skipFailedInvocations() {
        return this.m_skipFailedInvocations;
    }

    @Override
    public void setSkipFailedInvocations(boolean s2) {
        this.m_skipFailedInvocations = s2;
    }

    public void setInvocationTimeOut(long timeOut) {
        this.m_invocationTimeOut = timeOut;
    }

    @Override
    public long getInvocationTimeOut() {
        return this.m_invocationTimeOut;
    }

    @Override
    public boolean ignoreMissingDependencies() {
        return this.m_ignoreMissingDependencies;
    }

    @Override
    public void setIgnoreMissingDependencies(boolean i) {
        this.m_ignoreMissingDependencies = i;
    }

    @Override
    public List<Integer> getInvocationNumbers() {
        return this.m_invocationNumbers;
    }

    @Override
    public void setInvocationNumbers(List<Integer> numbers) {
        this.m_invocationNumbers = numbers;
    }

    @Override
    public List<Integer> getFailedInvocationNumbers() {
        return new ArrayList<Integer>(this.m_failedInvocationNumbers);
    }

    @Override
    public void addFailedInvocationNumber(int number) {
        this.m_failedInvocationNumbers.add(number);
    }

    @Override
    public int getPriority() {
        return this.m_priority;
    }

    @Override
    public void setPriority(int priority) {
        this.m_priority = priority;
    }

    @Override
    public int getInterceptedPriority() {
        return this.m_interceptedPriority;
    }

    @Override
    public void setInterceptedPriority(int priority) {
        this.m_interceptedPriority = priority;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_xmlTest;
    }

    public void setXmlTest(XmlTest xmlTest) {
        this.m_xmlTest = xmlTest;
    }

    @Override
    public ConstructorOrMethod getConstructorOrMethod() {
        return this.m_method;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.m_method.getParameterTypes();
    }

    @Override
    public Map<String, String> findMethodParameters(XmlTest test) {
        return XmlTestUtils.findMethodParameters(test, this.getTestClass().getName(), this.getMethodName());
    }

    @Override
    public String getQualifiedName() {
        return this.getRealClass().getName() + "." + this.getMethodName();
    }

    @Override
    public IParameterInfo getFactoryMethodParamsInfo() {
        if (this.m_instance instanceof IParameterInfo) {
            return (IParameterInfo)this.m_instance;
        }
        return null;
    }

    @Override
    public void setInvokedAt(long date) {
        this.invocationTime = date;
    }

    @Override
    public long getInvocationTime() {
        return this.invocationTime;
    }

    private IRetryAnalyzer getRetryAnalyzerConsideringMethodParameters(ITestResult tr) {
        if (this.m_retryAnalyzerClass.equals(DisabledRetryAnalyzer.class)) {
            return null;
        }
        if (BaseTestMethod.isNotParameterisedTest(tr)) {
            this.m_retryAnalyzer = this.computeRetryAnalyzerInstanceToUse(tr);
            return this.m_retryAnalyzer;
        }
        String keyAsString = this.getSimpleName() + "#" + this.getParameterInvocationCount();
        IRetryAnalyzer currentRetryAnalyzerInMap = this.m_testMethodToRetryAnalyzer.get(keyAsString);
        if (currentRetryAnalyzerInMap != null) {
            return currentRetryAnalyzerInMap;
        }
        BasicAttributes ba = new BasicAttributes(null, this.m_retryAnalyzerClass);
        CreationAttributes attributes = new CreationAttributes(tr.getTestContext(), ba, null);
        IRetryAnalyzer instance = (IRetryAnalyzer)Dispenser.newInstance(this.m_objectFactory).dispense(attributes);
        this.m_testMethodToRetryAnalyzer.put(keyAsString, instance);
        return instance;
    }

    private static boolean isNotParameterisedTest(ITestResult tr) {
        return Optional.ofNullable(tr.getParameters()).orElse(new Object[0]).length == 0;
    }

    private IRetryAnalyzer computeRetryAnalyzerInstanceToUse(ITestResult tr) {
        if (this.m_retryAnalyzer != null) {
            return this.m_retryAnalyzer;
        }
        if (this.m_retryAnalyzerClass.equals(DisabledRetryAnalyzer.class)) {
            return null;
        }
        BasicAttributes ba = new BasicAttributes(null, this.m_retryAnalyzerClass);
        CreationAttributes attributes = new CreationAttributes(tr.getTestContext(), ba, null);
        return (IRetryAnalyzer)Dispenser.newInstance(this.m_objectFactory).dispense(attributes);
    }
}

