/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ReflectUtil {
    private static Class[] getParameterTypes(Object[] parameters) {
        Class[] parameterTypes = null;
        if (ArrayUtils.isEmpty(parameters)) {
            return null;
        }
        parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        return parameterTypes;
    }

    public static Constructor getConstructor(Class targetClass, Object ... parameters) throws NoSuchMethodException {
        return (Constructor)ReflectUtil.reflect((Executable[])targetClass.getConstructors(), (T candidate) -> true, (String)".<init>", (Class)targetClass, (Object[])parameters);
    }

    public static Method getMethod(Class targetClass, String name, Object ... parameters) throws NoSuchMethodException {
        return (Method)ReflectUtil.reflect((Executable[])targetClass.getMethods(), (T candidate) -> StringUtils.equals(name, candidate.getName()), (String)("." + name), (Class)targetClass, (Object[])parameters);
    }

    private static <T extends Executable> T reflect(T[] candidates, Function<T, Boolean> filter, String message, Class targetClass, Object ... parameters) throws NoSuchMethodException {
        Class[] parameterTypes = ReflectUtil.getParameterTypes(parameters);
        Executable result = null;
        for (int i = 0; i < candidates.length; ++i) {
            T candidate = candidates[i];
            if (!filter.apply(candidate).booleanValue() || !ReflectUtil.assignable(parameterTypes, ((Executable)candidate).getParameterTypes()) || result != null && !ReflectUtil.assignable(((Executable)candidate).getParameterTypes(), result.getParameterTypes())) continue;
            result = (Executable)candidate;
        }
        if (result == null) {
            throw new NoSuchMethodException(targetClass.getName() + message + ReflectUtil.argumentTypesToString(parameterTypes));
        }
        return (T)result;
    }

    private static boolean assignable(Class[] from, Class[] to) {
        if (from == null) {
            return to == null || to.length == 0;
        }
        if (to == null) {
            return from.length == 0;
        }
        if (from.length != to.length) {
            return false;
        }
        for (int i = 0; i < from.length; ++i) {
            if (to[i].isAssignableFrom(from[i])) continue;
            return false;
        }
        return true;
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static List<String> getMethodStrings(Class targetClass) {
        if (targetClass == null) {
            return null;
        }
        Method[] methods = targetClass.getMethods();
        if (methods == null || methods.length == 0) {
            return null;
        }
        ArrayList<String> methodStrings = new ArrayList<String>();
        for (int i = 0; i < methods.length; ++i) {
            methodStrings.add(methods[i].toString());
        }
        return methodStrings;
    }

    public static <T> List<T> getInstancesByClassNames(String classNames, Class<T> cls) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        String[] classNameArray = StringUtils.split(classNames, ";");
        ArrayList isntances = new ArrayList();
        for (String className : classNameArray) {
            isntances.add(Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        return isntances;
    }
}

