/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.deployment;

import io.ray.serve.api.Serve;
import io.ray.serve.config.AutoscalingConfig;
import io.ray.serve.config.DeploymentConfig;
import io.ray.serve.config.ReplicaConfig;
import io.ray.serve.deployment.Application;
import io.ray.serve.deployment.Deployment;
import io.ray.serve.generated.DeploymentLanguage;
import io.ray.serve.util.CommonUtil;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Serve.class);
    private String deploymentDef;
    private String name;
    @Deprecated
    private String version;
    private Integer numReplicas;
    private Object[] initArgs;
    private Map<String, Object> rayActorOptions;
    private Object userConfig;
    private Integer maxOngoingRequests;
    private AutoscalingConfig autoscalingConfig;
    private Double gracefulShutdownWaitLoopS;
    private Double gracefulShutdownTimeoutS;
    private Double healthCheckPeriodS;
    private Double healthCheckTimeoutS;
    private DeploymentLanguage language;

    public Deployment create(boolean check) {
        if (check) {
            Preconditions.checkArgument(this.numReplicas == null || this.numReplicas != 0, "num_replicas is expected to larger than 0");
            Preconditions.checkArgument(this.numReplicas == null || this.autoscalingConfig == null, "Manually setting num_replicas is not allowed when autoscalingConfig is provided.");
        }
        if (this.version != null) {
            LOGGER.warn("DeprecationWarning: `version` in `@serve.deployment` has been deprecated. Explicitly specifying version will raise an error in the future!");
        }
        DeploymentConfig deploymentConfig = new DeploymentConfig().setNumReplicas(this.numReplicas != null ? this.numReplicas : 1).setMaxOngoingRequests(this.maxOngoingRequests).setUserConfig(this.userConfig).setAutoscalingConfig(this.autoscalingConfig).setGracefulShutdownWaitLoopS(this.gracefulShutdownWaitLoopS).setGracefulShutdownTimeoutS(this.gracefulShutdownTimeoutS).setHealthCheckPeriodS(this.healthCheckPeriodS).setHealthCheckTimeoutS(this.healthCheckTimeoutS).setDeploymentLanguage(this.language);
        ReplicaConfig replicaConfig = new ReplicaConfig(this.deploymentDef, this.initArgs, this.rayActorOptions);
        return new Deployment(StringUtils.isNotBlank(this.name) ? this.name : CommonUtil.getDeploymentName(this.deploymentDef), deploymentConfig, replicaConfig, this.version);
    }

    public Deployment create() {
        return this.create(true);
    }

    public Application bind(Object ... args) {
        return this.create().bind(args);
    }

    public String getDeploymentDef() {
        return this.deploymentDef;
    }

    public DeploymentCreator setDeploymentDef(String deploymentDef) {
        this.deploymentDef = deploymentDef;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DeploymentCreator setName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public DeploymentCreator setVersion(String version) {
        this.version = version;
        return this;
    }

    public Integer getNumReplicas() {
        return this.numReplicas;
    }

    public DeploymentCreator setNumReplicas(Integer numReplicas) {
        this.numReplicas = numReplicas;
        return this;
    }

    public Object[] getInitArgs() {
        return this.initArgs;
    }

    public DeploymentCreator setInitArgs(Object[] initArgs) {
        this.initArgs = initArgs;
        return this;
    }

    public Map<String, Object> getRayActorOptions() {
        return this.rayActorOptions;
    }

    public DeploymentCreator setRayActorOptions(Map<String, Object> rayActorOptions) {
        this.rayActorOptions = rayActorOptions;
        return this;
    }

    public Object getUserConfig() {
        return this.userConfig;
    }

    public DeploymentCreator setUserConfig(Object userConfig) {
        this.userConfig = userConfig;
        return this;
    }

    public Integer getMaxOngoingRequests() {
        return this.maxOngoingRequests;
    }

    public DeploymentCreator setMaxOngoingRequests(Integer maxOngoingRequests) {
        this.maxOngoingRequests = maxOngoingRequests;
        return this;
    }

    public AutoscalingConfig getAutoscalingConfig() {
        return this.autoscalingConfig;
    }

    public DeploymentCreator setAutoscalingConfig(AutoscalingConfig autoscalingConfig) {
        this.autoscalingConfig = autoscalingConfig;
        return this;
    }

    public Double getGracefulShutdownWaitLoopS() {
        return this.gracefulShutdownWaitLoopS;
    }

    public DeploymentCreator setGracefulShutdownWaitLoopS(Double gracefulShutdownWaitLoopS) {
        this.gracefulShutdownWaitLoopS = gracefulShutdownWaitLoopS;
        return this;
    }

    public Double getGracefulShutdownTimeoutS() {
        return this.gracefulShutdownTimeoutS;
    }

    public DeploymentCreator setGracefulShutdownTimeoutS(Double gracefulShutdownTimeoutS) {
        this.gracefulShutdownTimeoutS = gracefulShutdownTimeoutS;
        return this;
    }

    public Double getHealthCheckPeriodS() {
        return this.healthCheckPeriodS;
    }

    public DeploymentCreator setHealthCheckPeriodS(Double healthCheckPeriodS) {
        this.healthCheckPeriodS = healthCheckPeriodS;
        return this;
    }

    public Double getHealthCheckTimeoutS() {
        return this.healthCheckTimeoutS;
    }

    public DeploymentCreator setHealthCheckTimeoutS(Double healthCheckTimeoutS) {
        this.healthCheckTimeoutS = healthCheckTimeoutS;
        return this;
    }

    public DeploymentLanguage getLanguage() {
        return this.language;
    }

    public DeploymentCreator setLanguage(DeploymentLanguage language) {
        this.language = language;
        return this;
    }
}

