/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util.generator;

import io.ray.runtime.util.generator.BaseGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;

public class RayFuncGenerator
extends BaseGenerator {
    private String generate(int numParameters, boolean hasReturn) {
        this.sb = new StringBuilder();
        String genericTypes = "";
        String paramList = "";
        for (int i = 0; i < numParameters; ++i) {
            genericTypes = genericTypes + "T" + i + ", ";
            if (i > 0) {
                paramList = paramList + ", ";
            }
            paramList = paramList + String.format("T%d t%d", i, i);
        }
        if (hasReturn) {
            genericTypes = genericTypes + "R, ";
        }
        if (!genericTypes.isEmpty()) {
            genericTypes = genericTypes.substring(0, genericTypes.length() - 2);
            genericTypes = "<" + genericTypes + ">";
        }
        this.newLine("// generated automatically, do not modify.");
        this.newLine("");
        this.newLine("package io.ray.api.function;");
        this.newLine("");
        this.newLine("/**");
        String comment = String.format(" * Functional interface for a remote function that has %d parameter%s.", numParameters, numParameters > 1 ? "s" : "");
        this.newLine(comment);
        this.newLine(" */");
        this.newLine("@FunctionalInterface");
        String className = "RayFunc" + (hasReturn ? "" : "Void") + numParameters;
        this.newLine(String.format("public interface %s%s extends %s {", className, genericTypes, hasReturn ? "RayFuncR<R>" : "RayFuncVoid"));
        this.newLine("");
        this.indents(1);
        this.newLine(String.format("%s apply(%s) throws Exception;", hasReturn ? "R" : "void", paramList));
        this.newLine("}");
        return this.sb.toString();
    }

    public static void main(String[] args) throws IOException {
        String root = System.getProperty("user.dir") + "/api/src/main/java/io/ray/api/function/";
        RayFuncGenerator generator = new RayFuncGenerator();
        for (int i = 0; i <= 6; ++i) {
            String content = generator.generate(i, true);
            FileUtils.write(new File(root + "RayFunc" + i + ".java"), (CharSequence)content, Charset.defaultCharset());
            content = generator.generate(i, false);
            FileUtils.write(new File(root + "RayFuncVoid" + i + ".java"), (CharSequence)content, Charset.defaultCharset());
        }
    }
}

