/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util;

import io.ray.api.concurrencygroup.ConcurrencyGroup;
import io.ray.api.concurrencygroup.annotations.DefConcurrencyGroup;
import io.ray.api.concurrencygroup.annotations.DefConcurrencyGroups;
import io.ray.api.concurrencygroup.annotations.UseConcurrencyGroup;
import io.ray.api.function.RayFuncR;
import io.ray.runtime.ConcurrencyGroupImpl;
import io.ray.runtime.functionmanager.JavaFunctionDescriptor;
import io.ray.runtime.util.LambdaUtils;
import io.ray.runtime.util.MethodUtils;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ConcurrencyGroupUtils {
    public static List<ConcurrencyGroup> extractConcurrencyGroupsByAnnotations(RayFuncR<?> actorConstructorLambda) {
        Method[] methods;
        Class<?>[] interfaces;
        SerializedLambda serializedLambda = LambdaUtils.getSerializedLambda(actorConstructorLambda);
        Class<?> actorClz = MethodUtils.getReturnTypeFromSignature(serializedLambda.getInstantiatedMethodType());
        ArrayList<ConcurrencyGroup> ret = new ArrayList<ConcurrencyGroup>();
        Map<String, ConcurrencyGroupImpl> allConcurrencyGroupsMap = ConcurrencyGroupUtils.extractConcurrencyGroupsFromClassAnnotation(actorClz);
        for (Class<?> interfaceClz : interfaces = actorClz.getInterfaces()) {
            Preconditions.checkState(interfaceClz != null);
            Map<String, ConcurrencyGroupImpl> currConcurrencyGroups = ConcurrencyGroupUtils.extractConcurrencyGroupsFromClassAnnotation(interfaceClz);
            allConcurrencyGroupsMap.putAll(currConcurrencyGroups);
        }
        for (Method method : methods = actorClz.getMethods()) {
            UseConcurrencyGroup useConcurrencyGroupAnnotation = method.getAnnotation(UseConcurrencyGroup.class);
            if (useConcurrencyGroupAnnotation == null) continue;
            String concurrencyGroupName = useConcurrencyGroupAnnotation.name();
            Preconditions.checkState(allConcurrencyGroupsMap.containsKey(concurrencyGroupName));
            allConcurrencyGroupsMap.get(concurrencyGroupName).addJavaFunctionDescriptor(new JavaFunctionDescriptor(method.getDeclaringClass().getName(), method.getName(), MethodUtils.getSignature(method)));
        }
        allConcurrencyGroupsMap.forEach((key, value) -> ret.add((ConcurrencyGroup)value));
        return ret;
    }

    private static Map<String, ConcurrencyGroupImpl> extractConcurrencyGroupsFromClassAnnotation(Class<?> clz) {
        HashMap<String, ConcurrencyGroupImpl> ret = new HashMap<String, ConcurrencyGroupImpl>();
        DefConcurrencyGroups concurrencyGroupsDefinitionAnnotation = clz.getAnnotation(DefConcurrencyGroups.class);
        if (concurrencyGroupsDefinitionAnnotation != null) {
            DefConcurrencyGroup[] defAnnotations = concurrencyGroupsDefinitionAnnotation.value();
            if (defAnnotations.length == 0) {
                throw new IllegalArgumentException("TODO");
            }
            for (DefConcurrencyGroup def : defAnnotations) {
                ret.put(def.name(), new ConcurrencyGroupImpl(def.name(), def.maxConcurrency()));
            }
        } else {
            DefConcurrencyGroup defConcurrencyGroup = clz.getAnnotation(DefConcurrencyGroup.class);
            if (defConcurrencyGroup != null) {
                ret.put(defConcurrencyGroup.name(), new ConcurrencyGroupImpl(defConcurrencyGroup.name(), defConcurrencyGroup.maxConcurrency()));
            } else {
                return ret;
            }
        }
        return ret;
    }
}

