/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.task;

import io.ray.api.id.ObjectId;
import io.ray.runtime.generated.Common;
import io.ray.runtime.object.NativeRayObject;
import io.ray.shaded.com.google.common.base.Preconditions;

public class FunctionArg {
    public final ObjectId id;
    public final Common.Address ownerAddress;
    public final NativeRayObject value;

    private FunctionArg(ObjectId id, Common.Address ownerAddress) {
        Preconditions.checkNotNull(id);
        Preconditions.checkNotNull(ownerAddress);
        this.id = id;
        this.ownerAddress = ownerAddress;
        this.value = null;
    }

    private FunctionArg(NativeRayObject nativeRayObject) {
        Preconditions.checkNotNull(nativeRayObject);
        this.id = null;
        this.ownerAddress = null;
        this.value = nativeRayObject;
    }

    public static FunctionArg passByReference(ObjectId id, Common.Address ownerAddress) {
        return new FunctionArg(id, ownerAddress);
    }

    public static FunctionArg passByValue(NativeRayObject value) {
        return new FunctionArg(value);
    }

    public String toString() {
        if (this.id != null) {
            return "<id>: " + this.id.toString();
        }
        return this.value.toString();
    }
}

