/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.serializer;

import io.ray.api.exception.CrossLanguageException;
import io.ray.api.exception.RayException;
import io.ray.runtime.generated.Common;
import io.ray.runtime.serializer.Serializer;
import io.ray.shaded.com.google.protobuf.ByteString;
import io.ray.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class RayExceptionSerializer {
    public static byte[] toBytes(RayException exception) {
        String formattedException = ExceptionUtils.getStackTrace(exception);
        Common.RayException.Builder builder = Common.RayException.newBuilder();
        builder.setLanguage(Common.Language.JAVA);
        builder.setFormattedExceptionString(formattedException);
        builder.setSerializedException(ByteString.copyFrom(Serializer.encode(exception).getLeft()));
        return builder.build().toByteArray();
    }

    public static RayException fromBytes(byte[] serialized) throws InvalidProtocolBufferException {
        Common.RayException exception = Common.RayException.parseFrom(serialized);
        if (exception.getLanguage() == Common.Language.JAVA) {
            return (RayException)Serializer.decode(exception.getSerializedException().toByteArray(), RayException.class);
        }
        return new CrossLanguageException(String.format("An exception raised from %s:\n%s", exception.getLanguage().name(), exception.getFormattedExceptionString()));
    }

    public static RayException fromRayExceptionPB(Common.RayException rayExceptionPB) {
        if (rayExceptionPB.getLanguage() == Common.Language.JAVA) {
            return (RayException)Serializer.decode(rayExceptionPB.getSerializedException().toByteArray(), RayException.class);
        }
        return new CrossLanguageException(String.format("An exception raised from %s:\n%s", rayExceptionPB.getLanguage().name(), rayExceptionPB.getFormattedExceptionString()));
    }
}

