/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.metric;

import io.ray.runtime.metric.Metric;
import io.ray.runtime.metric.NativeMetric;
import io.ray.runtime.metric.TagKey;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Histogram
extends Metric {
    private List<Double> histogramWindow;
    public static final int HISTOGRAM_WINDOW_SIZE = 100;

    @Deprecated
    public Histogram(String name, String description, String unit, List<Double> boundaries, Map<TagKey, String> tags) {
        super(name, tags);
        this.metricNativePointer = NativeMetric.registerHistogramNative(name, description, unit, boundaries.stream().mapToDouble(Double::doubleValue).toArray(), tags.keySet().stream().map(TagKey::getTagKey).collect(Collectors.toList()));
        Preconditions.checkState(this.metricNativePointer != 0L, "Histogram native pointer must not be 0.");
        this.histogramWindow = Collections.synchronizedList(new ArrayList());
    }

    public Histogram(String name, String description, List<Double> boundaries, Map<String, String> tags) {
        this(name, description, "", boundaries, TagKey.tagsFromMap(tags));
    }

    private void updateForWindow(double value) {
        if (this.histogramWindow.size() == 100) {
            this.histogramWindow.remove(0);
        }
        this.histogramWindow.add(value);
    }

    @Override
    public void update(double value) {
        this.updateForWindow(value);
        this.value.set(value);
    }

    @Override
    protected double getAndReset() {
        this.histogramWindow.clear();
        return this.value.doubleValue();
    }

    public List<Double> getHistogramWindow() {
        return this.histogramWindow;
    }

    public double getValue() {
        return this.value.get();
    }
}

