/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.gcs;

import io.ray.api.id.ActorId;
import io.ray.api.id.JobId;
import io.ray.api.id.PlacementGroupId;
import io.ray.api.runtimecontext.ActorState;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.List;

public class GlobalStateAccessor {
    private Long globalStateAccessorNativePointer = 0L;
    private static GlobalStateAccessor globalStateAccessor;

    public static synchronized GlobalStateAccessor getInstance(String bootstrapAddress, String redisUsername, String redisPassword) {
        if (null == globalStateAccessor) {
            globalStateAccessor = new GlobalStateAccessor(bootstrapAddress, redisUsername, redisPassword);
        }
        return globalStateAccessor;
    }

    public static synchronized void destroyInstance() {
        if (null != globalStateAccessor) {
            globalStateAccessor.destroyGlobalStateAccessor();
            globalStateAccessor = null;
        }
    }

    private GlobalStateAccessor(String bootstrapAddress, String redisUsername, String redisPassword) {
        this.globalStateAccessorNativePointer = this.nativeCreateGlobalStateAccessor(bootstrapAddress, redisUsername, redisPassword);
        this.validateGlobalStateAccessorPointer();
        this.connect();
    }

    private boolean connect() {
        return this.nativeConnect(this.globalStateAccessorNativePointer);
    }

    private void validateGlobalStateAccessorPointer() {
        Preconditions.checkState(this.globalStateAccessorNativePointer != 0L, "Global state accessor native pointer must not be 0.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getAllJobInfo() {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            this.validateGlobalStateAccessorPointer();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nativeGetAllJobInfo(this.globalStateAccessorNativePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getNextJobID() {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            this.validateGlobalStateAccessorPointer();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nativeGetNextJobID(this.globalStateAccessorNativePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getAllNodeInfo() {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            this.validateGlobalStateAccessorPointer();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nativeGetAllNodeInfo(this.globalStateAccessorNativePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPlacementGroupInfo(PlacementGroupId placementGroupId) {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            this.validateGlobalStateAccessorPointer();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.nativeGetPlacementGroupInfo(this.globalStateAccessorNativePointer, placementGroupId.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPlacementGroupInfo(String name, String namespace) {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            this.validateGlobalStateAccessorPointer();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.nativeGetPlacementGroupInfoByName(this.globalStateAccessorNativePointer, name, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getAllPlacementGroupInfo() {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            this.validateGlobalStateAccessorPointer();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nativeGetAllPlacementGroupInfo(this.globalStateAccessorNativePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getInternalKV(String n, String k) {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            this.validateGlobalStateAccessorPointer();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.nativeGetInternalKV(this.globalStateAccessorNativePointer, n, k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getAllActorInfo(JobId jobId, ActorState actorState) {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            this.validateGlobalStateAccessorPointer();
            byte[] jobIdBytes = null;
            String actorStateName = null;
            if (jobId != null) {
                jobIdBytes = jobId.getBytes();
            }
            if (actorState != null) {
                actorStateName = actorState.getName();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.nativeGetAllActorInfo(this.globalStateAccessorNativePointer, jobIdBytes, actorStateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getActorInfo(ActorId actorId) {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            this.validateGlobalStateAccessorPointer();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.nativeGetActorInfo(this.globalStateAccessorNativePointer, actorId.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getNodeToConnectForDriver(String nodeIpAddress) {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            this.validateGlobalStateAccessorPointer();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.nativeGetNodeToConnectForDriver(this.globalStateAccessorNativePointer, nodeIpAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyGlobalStateAccessor() {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            if (0L == this.globalStateAccessorNativePointer) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.nativeDestroyGlobalStateAccessor(this.globalStateAccessorNativePointer);
            this.globalStateAccessorNativePointer = 0L;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private native long nativeCreateGlobalStateAccessor(String var1, String var2, String var3);

    private native void nativeDestroyGlobalStateAccessor(long var1);

    private native boolean nativeConnect(long var1);

    private native List<byte[]> nativeGetAllJobInfo(long var1);

    private native byte[] nativeGetNextJobID(long var1);

    private native List<byte[]> nativeGetAllNodeInfo(long var1);

    private native List<byte[]> nativeGetAllActorInfo(long var1, byte[] var3, String var4);

    private native byte[] nativeGetActorInfo(long var1, byte[] var3);

    private native byte[] nativeGetPlacementGroupInfo(long var1, byte[] var3);

    private native byte[] nativeGetPlacementGroupInfoByName(long var1, String var3, String var4);

    private native List<byte[]> nativeGetAllPlacementGroupInfo(long var1);

    private native byte[] nativeGetInternalKV(long var1, String var3, String var4);

    private native byte[] nativeGetNodeToConnectForDriver(long var1, String var3);
}

