/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.options;

import io.ray.api.concurrencygroup.ConcurrencyGroup;
import io.ray.api.options.ActorLifetime;
import io.ray.api.options.BaseTaskOptions;
import io.ray.api.placementgroup.PlacementGroup;
import io.ray.api.runtimeenv.RuntimeEnv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActorCreationOptions
extends BaseTaskOptions {
    public static final int NO_RESTART = 0;
    public static final int INFINITE_RESTART = -1;
    private final String name;
    private final ActorLifetime lifetime;
    private final int maxRestarts;
    private final int maxTaskRetries;
    private final List<String> jvmOptions;
    private final int maxConcurrency;
    private final PlacementGroup group;
    private final int bundleIndex;
    private final List<ConcurrencyGroup> concurrencyGroups;
    private final String serializedRuntimeEnv;
    private final String namespace;
    private final int maxPendingCalls;
    private final boolean isAsync;
    private final boolean allowOutOfOrderExecution;

    private ActorCreationOptions(Builder builder) {
        super(builder.resources);
        this.name = builder.name;
        this.lifetime = builder.lifetime;
        this.maxRestarts = builder.maxRestarts;
        this.maxTaskRetries = builder.maxTaskRetries;
        this.jvmOptions = builder.jvmOptions != null ? Collections.unmodifiableList(builder.jvmOptions) : null;
        this.maxConcurrency = builder.maxConcurrency;
        this.group = builder.group;
        this.bundleIndex = builder.bundleIndex;
        this.concurrencyGroups = builder.concurrencyGroups != null ? Collections.unmodifiableList(builder.concurrencyGroups) : null;
        this.serializedRuntimeEnv = builder.runtimeEnv != null ? builder.runtimeEnv.serializeToRuntimeEnvInfo() : "";
        this.namespace = builder.namespace;
        this.maxPendingCalls = builder.maxPendingCalls;
        this.isAsync = builder.isAsync;
        this.allowOutOfOrderExecution = builder.isAsync;
    }

    public String getName() {
        return this.name;
    }

    public ActorLifetime getLifetime() {
        return this.lifetime;
    }

    public int getMaxRestarts() {
        return this.maxRestarts;
    }

    public int getMaxTaskRetries() {
        return this.maxTaskRetries;
    }

    public List<String> getJvmOptions() {
        return this.jvmOptions;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public PlacementGroup getGroup() {
        return this.group;
    }

    public int getBundleIndex() {
        return this.bundleIndex;
    }

    public List<ConcurrencyGroup> getConcurrencyGroups() {
        return this.concurrencyGroups;
    }

    public String getSerializedRuntimeEnv() {
        return this.serializedRuntimeEnv;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getMaxPendingCalls() {
        return this.maxPendingCalls;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public boolean allowsOutOfOrderExecution() {
        return this.allowOutOfOrderExecution;
    }

    public static class Builder {
        private String name;
        private ActorLifetime lifetime = null;
        private final Map<String, Double> resources = new HashMap<String, Double>();
        private int maxRestarts = 0;
        private int maxTaskRetries = 0;
        private List<String> jvmOptions = new ArrayList<String>();
        private int maxConcurrency = 1;
        private PlacementGroup group;
        private int bundleIndex;
        private List<ConcurrencyGroup> concurrencyGroups = new ArrayList<ConcurrencyGroup>();
        private RuntimeEnv runtimeEnv = null;
        private String namespace = null;
        private int maxPendingCalls = -1;
        private boolean isAsync = false;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setLifetime(ActorLifetime lifetime) {
            this.lifetime = lifetime;
            return this;
        }

        public Builder setResource(String resourceName, Double resourceQuantity) {
            this.resources.put(resourceName, resourceQuantity);
            return this;
        }

        public Builder setResources(Map<String, Double> resources) {
            this.resources.putAll(resources);
            return this;
        }

        public Builder setMaxRestarts(int maxRestarts) {
            this.maxRestarts = maxRestarts;
            return this;
        }

        public Builder setMaxTaskRetries(int maxTaskRetries) {
            this.maxTaskRetries = maxTaskRetries;
            return this;
        }

        public Builder setJvmOptions(List<String> jvmOptions) {
            this.jvmOptions = jvmOptions;
            return this;
        }

        public Builder setMaxConcurrency(int maxConcurrency) {
            if (maxConcurrency <= 0) {
                throw new IllegalArgumentException("maxConcurrency must be greater than 0.");
            }
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder setMaxPendingCalls(int maxPendingCalls) {
            if (maxPendingCalls < -1 || maxPendingCalls == 0) {
                throw new IllegalArgumentException("maxPendingCalls must be greater than 0, or -1 to disable.");
            }
            this.maxPendingCalls = maxPendingCalls;
            return this;
        }

        public Builder setAsync(boolean isAsync) {
            this.isAsync = isAsync;
            return this;
        }

        public Builder setPlacementGroup(PlacementGroup group, int bundleIndex) {
            this.group = group;
            this.bundleIndex = bundleIndex;
            return this;
        }

        public Builder setConcurrencyGroups(List<ConcurrencyGroup> concurrencyGroups) {
            this.concurrencyGroups = concurrencyGroups;
            return this;
        }

        public Builder setRuntimeEnv(RuntimeEnv runtimeEnv) {
            this.runtimeEnv = runtimeEnv;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ActorCreationOptions build() {
            return new ActorCreationOptions(this);
        }
    }
}

