/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.draftv3;

import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers.SchemaMapSyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import io.ray.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.ray.shaded.com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;

public final class DraftV3PropertiesSyntaxChecker
extends SchemaMapSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV3PropertiesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV3PropertiesSyntaxChecker() {
        super("properties");
    }

    @Override
    protected void extraChecks(ProcessingReport report, MessageBundle bundle, SchemaTree tree) throws ProcessingException {
        TreeMap<String, JsonNode> map = Maps.newTreeMap();
        map.putAll(JacksonUtils.asMap(tree.getNode().get(this.keyword)));
        for (Map.Entry entry : map.entrySet()) {
            NodeType type;
            String member = (String)entry.getKey();
            JsonNode required = ((JsonNode)entry.getValue()).get("required");
            if (required == null || (type = NodeType.getNodeType(required)) == NodeType.BOOLEAN) continue;
            report.error(this.newMsg(tree, bundle, "draftv3.properties.required.incorrectType").putArgument("property", member).putArgument("found", type).put("expected", NodeType.BOOLEAN));
        }
    }
}

