/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.common;

import com.github.fge.jackson.JsonNumEquivalence;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import io.ray.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.ray.shaded.com.google.common.base.Equivalence;
import io.ray.shaded.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;

public final class EnumSyntaxChecker
extends AbstractSyntaxChecker {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquivalence.getInstance();
    private static final SyntaxChecker INSTANCE = new EnumSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private EnumSyntaxChecker() {
        super("enum", NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        HashSet<Equivalence.Wrapper<JsonNode>> set = Sets.newHashSet();
        for (JsonNode element : this.getNode(tree)) {
            if (set.add(EQUIVALENCE.wrap(element))) continue;
            report.error(this.newMsg(tree, bundle, "common.array.duplicateElements"));
            return;
        }
    }
}

