/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.github.fge.jackson.NodeType;
import io.ray.shaded.com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public final class JsonNumEquals {
    private static final JsonNumEquals INSTANCE = new JsonNumEquals();

    private JsonNumEquals() {
    }

    public static JsonNumEquals getInstance() {
        return INSTANCE;
    }

    public final boolean equivalent(@Nullable JsonNode a, @Nullable JsonNode b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return this.doEquivalent(a, b);
    }

    protected boolean doEquivalent(JsonNode a, JsonNode b) {
        NodeType typeB;
        if (a.isNumber() && b.isNumber()) {
            return JsonNumEquals.numEquals(a, b);
        }
        NodeType typeA = NodeType.getNodeType(a);
        if (typeA != (typeB = NodeType.getNodeType(b))) {
            return false;
        }
        if (!a.isContainerNode()) {
            return a.equals(b);
        }
        if (a.size() != b.size()) {
            return false;
        }
        return typeA == NodeType.ARRAY ? this.arrayEquals(a, b) : this.objectEquals(a, b);
    }

    public final int hash(@Nullable JsonNode t2) {
        if (t2 == null) {
            return 0;
        }
        return this.doHash(t2);
    }

    protected int doHash(JsonNode t2) {
        if (t2.isNumber()) {
            return Double.valueOf(t2.doubleValue()).hashCode();
        }
        if (!t2.isContainerNode()) {
            return t2.hashCode();
        }
        int ret = 0;
        if (t2.size() == 0) {
            return ret;
        }
        if (t2.isArray()) {
            for (JsonNode element : t2) {
                ret = 31 * ret + this.hash(element);
            }
            return ret;
        }
        Iterator<Map.Entry<String, JsonNode>> iterator = t2.fields();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            ret = 31 * ret + (entry.getKey().hashCode() ^ this.hash(entry.getValue()));
        }
        return ret;
    }

    private static boolean numEquals(JsonNode a, JsonNode b) {
        if (a.isIntegralNumber() && b.isIntegralNumber()) {
            return a.equals(b);
        }
        return a.decimalValue().compareTo(b.decimalValue()) == 0;
    }

    private boolean arrayEquals(JsonNode a, JsonNode b) {
        int size = a.size();
        for (int i = 0; i < size; ++i) {
            if (this.equivalent(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean objectEquals(JsonNode a, JsonNode b) {
        HashSet<String> keys = new HashSet<String>();
        Iterator<String> iterator1 = a.fieldNames();
        while (iterator1.hasNext()) {
            String next = iterator1.next();
            if (next != null) {
                keys.add(next);
                continue;
            }
            throw new NullPointerException();
        }
        HashSet<String> set = new HashSet<String>();
        Iterator<String> iterator2 = b.fieldNames();
        while (iterator2.hasNext()) {
            String next = iterator2.next();
            if (next != null) {
                set.add(next);
                continue;
            }
            throw new NullPointerException();
        }
        if (!set.equals(keys)) {
            return false;
        }
        for (String key : keys) {
            if (this.equivalent(a.get(key), b.get(key))) continue;
            return false;
        }
        return true;
    }
}

